#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

from yql.api.v1.client import YqlClient

from os import getenv

if __name__ == '__main__':
    yql_token = getenv('MPFS_STAT_YQL_TOKEN')

    scripts = getenv('SCRIPTS')

    if scripts is None:
        quit()

    with YqlClient(db='hahn', token=yql_token) as yql_client:
        for script_name in scripts.split(','):
            with open('scripts/%s.yql' % script_name, 'r') as f:
                query = f.read()

                request = yql_client.query(query, syntax_version=1)
                request.run()
