ModalEdit = function($element, url) {
    var self = this;

    self.$element = $element;

    self.$error = self.$element.find('.error');
    self.$content = self.$element.find('.content');

    self.$title = self.$element.find('.modal-title');
    self.$id = self.$element.find('.modal-edit-id');
    self.$idInput = self.$id.find(':input');

    self.loadSaveUrl = url;

    self.$element.find('.submit').click(function() {
        self.save();
    });

    self.$element.on('shown.bs.modal', function() {
        self.$idInput.focus();
    });
};

ModalEdit.prototype = {
    title: function(id) {
        return id;
    },

    clear: function() {
        this.$element.find(':input').val('');
    },

    deserialize: function(data) {
        var $form = this.$element.find('form');

        $.each(data, function(key, value) {
            $form.find(':input[name=\'' + key + '\']').val(value);
        })
    },

    serialize: function() {
        return this.$element.find('form').serializeJSON();
    },

    edit: function(id) {
        var self = this;

        self.clear();

        self.$title.text(self.title(id));
        self.$idInput.val(id);
        self.$id.hide();

        self.load(id);

        return false;
    },

    clone: function(id) {
        var self = this;

        self.clear();

        self.$title.hide();
        self.$idInput.val('');
        self.$id.show();

        self.load(id).done(function() {
            self.$idInput.val('');
        });
        return false;
    },

    create: function() {
        var self = this;

        self.clear();

        self.$title.hide();
        self.$idInput.val('');
        self.$id.show();

        self.$error.hide();
        self.$content.show();
        self.$element.modal();

        return false;
    },

    load: function(id) {
        var self = this, defer = $.Deferred();

        self.$content.hide();
        self.$error.hide();

        $.ajax(
            self.loadSaveUrl.replace('{id}', id)

        ).done(function(data) {
            if (data.stackTrace) {
                self.showError(data.message, data.stackTrace);

            } else {
                self.deserialize(data);
                self.$content.show();
                self.updateHeight();

                defer.resolve();
            }
        }).fail(function(data) {
            self.showError(data.status + ' ' + data.statusText);
        });

        self.$element.modal();
        return defer.promise();
    },

    save: function() {
        var self = this, id = self.$idInput.val();

        self.$error.hide();
        self.updateHeight();

        $.ajax(self.loadSaveUrl.replace('{id}', id), {
            method: 'POST',
            dataType: 'json',
            contentType: 'application/json',
            data: self.serialize()

        }).done(function(data) {
            if (!data) {
                window.location.hash = id;
                window.location.reload();

            } else {
                self.showError(data.message, data.stackTrace);
            }
        }).fail(function(data) {
            self.showError(data.status + ' ' + data.statusText);
        });
    },

    updateHeight: function() {
        this.$element.data('bs.modal').handleUpdate();
    },

    showError: function(message, stacktrace) {
        var self = this;

        self.$error.find('.error-message').text(message);
        self.$error.find('.error-stacktrace').text((stacktrace || '').split('\n').slice(0, 8).join('\n'));
        self.$error.show();

        self.$element.animate({ scrollTop: 0 }, 100);

        self.updateHeight();
    }
};
