<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:template name="modal-edit-form">
        <xsl:param name="id"/>
        <xsl:param name="size" select="'lg'"/>
        <xsl:param name="content"/>
        <xsl:param name="btn-text" select="'Save changes'"/>
        <xsl:param name="btn-type" select="'button'"/>
        <xsl:param name="title" select="''"/>

        <div class="modal fade {$id}">
            <div class="modal-dialog modal-{$size}">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">
                            <xsl:value-of select="$title"/>
                        </h4>
                    </div>
                    <div class="modal-body">
                        <div class="error alert alert-danger" style="display: none">
                            <div class="error-message"/>
                            <pre class="alert-danger error-stacktrace"/>
                        </div>
                        <div class="content">
                            <xsl:copy-of select="$content"/>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="{$btn-type}" class="btn btn-primary submit"><xsl:value-of select="$btn-text"/></button>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
