!function() {
    function previousValue() {
        return this.$element.val().replace(/[^,]*$/, '');
    }

    function extractor(query) {
        var result = /([^,]+)$/.exec(query);

        if (result && result[1]) {
            return result[1].trim();
        }
        return '';
    }

    function updater(item) {
        var previous = previousValue.call(this);

        return previous + (previous ? ' ' : '') + item + ', ';
    }

    function matcher(item) {
        var query = extractor.call(this, this.query);

        if (!query) return false;

        var values = $.map(previousValue.call(this).split(','), function(value) {
            return value.trim() || [];
        });

        if (~values.indexOf(item.toLowerCase())) {
            return false;
        }
        return ~item.toLowerCase().indexOf(query.toLowerCase());
    }

    function highlighter(item) {
        var query = extractor.call(this, this.query).replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, '\\$&');

        return item.replace(new RegExp('(' + query + ')', 'ig'), function($1, match) {
            return '<strong>' + match + '</strong>'
        });
    }

    jQuery.fn.extend({
        typeaheadMulti: function(options) {
            return this.typeahead($.extend({}, options, {
                updater: updater,
                matcher: matcher,
                highlighter: highlighter
            }));
        }
    });

    jQuery(document).on('focus.typeahead.data-api', '[data-provide="typeaheadMulti"]', function() {
        var $this = $(this);
        if ($this.data('typeahead')) return;

        $this.typeaheadMulti($this.data());
    });
}();
