package ru.yandex.chemodan.alice;

import java.util.List;

import javax.servlet.http.HttpServlet;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.inside.passport.tvm2.Tvm2;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class
})
public class AliceContextConfiguration {
    @Bean
    public HttpServlet aliceServlet(DiskJetty a3Jetty, Tvm2 tvm2, List<AliceScenario> scenarios) {
        AliceScenarioServlet servlet = new AliceScenarioServlet(scenarios, tvm2);
        a3Jetty.addServletMapping("/api/alice/*", servlet);
        return servlet;
    }
}
