package ru.yandex.chemodan.alice;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.alice.megamind.protos.common.FrameProto;
import ru.yandex.alice.megamind.protos.scenarios.RequestProto;
import ru.yandex.alice.megamind.protos.scenarios.ResponseProto;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.TvmHeaders;
import ru.yandex.inside.passport.tvm2.exceptions.IncorrectTvmUserTicketException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.web.servlet.HttpServletResponseX;
import ru.yandex.passport.tvmauth.CheckedUserTicket;

/**
 * @author yashunsky
 * Copy-paste from ru.yandex.chemodan.app.hackathon.AliceScenarioServlet without hackaton hacks
 */
public class AliceScenarioServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AliceScenarioServlet.class);
    private final ExtensionRegistry registry = ExtensionRegistry.newInstance();

    private final ListF<AliceScenario> scenarios;

    private final Tvm2 tvm2;

    public AliceScenarioServlet(List<AliceScenario> scenarios, Tvm2 tvm2) {
        this.scenarios = Cf.x(scenarios);
        this.tvm2 = tvm2;

        RequestProto.getDescriptor().getExtensions().forEach(this.registry::add);
        ResponseProto.getDescriptor().getExtensions().forEach(this.registry::add);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequestX reqX = HttpServletRequestX.wrap(req);
        HttpServletResponseX respX = HttpServletResponseX.wrap(resp);

        Option<Long> uid = extractUid(reqX);
        logger.debug("extracted uid: {}", uid);

        Option<Message> messageO = processRequest(uid, reqX);

        if (messageO.isPresent()) {
            serializeResponse(reqX, respX, messageO.get());
        } else {
            respX.setStatus(400);
            respX.writeContent(("Unknown method " + reqX.getPathInfo()).getBytes(), "text/plain");
            logger.error("Unknown method: {}", reqX.getPathInfo());
        }
    }

    private Option<Message> processRequest(Option<Long> uid, HttpServletRequestX reqX) {
        Message message;
        switch (reqX.getPathInfo()) {
            case "/run": message = processRunRequest(uid, reqX); break;
            case "/apply": message = processApplyRequest(uid, reqX); break;
            case "/commit": message = processCommitRequest(uid, reqX); break;
            default: {
                return Option.empty();
            }
        }
        return Option.of(message);
    }

    private <T> T parseRequest(HttpServletRequestX reqX, com.google.protobuf.GeneratedMessageV3.Builder builder, Class<T> clazz) {
        try {
            byte[] data = reqX.getInputStreamX().readBytes();

            if ("application/json".equals(reqX.getContentType())) {
                JsonFormat.parser().merge(new StringReader(new String(data)), builder);
                return (T) builder.build();
            } else {
                return (T) builder.mergeFrom(data, registry).build();
            }
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private Message processRunRequest(Option<Long> uid, HttpServletRequestX reqX) {
        RequestProto.TScenarioRunRequest request = parseRequest(
                reqX, RequestProto.TScenarioRunRequest.newBuilder(), RequestProto.TScenarioRunRequest.class);
        logger.info("runRequest: {}", serializeMessageJson(request));

        SetF<String> intents = Cf.x(request.getInput().getSemanticFramesList()).map(FrameProto.TSemanticFrame::getName).unique();

        Option<AliceScenario> matchingScenario = scenarios.find(scenario -> intents.containsTs(scenario.getIntentName()));

        if (!matchingScenario.isPresent()) {
            return AliceUtils.createSimpleTextResponse("Я такого не умею");
        }

        return matchingScenario.get().run(uid, request);
    }

    private Message processApplyRequest(Option<Long> uid, HttpServletRequestX reqX) {
        RequestProto.TScenarioApplyRequest request = parseRequest(
                reqX, RequestProto.TScenarioApplyRequest.newBuilder(), RequestProto.TScenarioApplyRequest.class);
        logger.info("applyRequest: {}", serializeMessageJson(request));
        return AliceUtils.createSimpleTextResponse("Метод Apply не поддержан");
    }

    private Message processCommitRequest(Option<Long> uid, HttpServletRequestX reqX) {
        RequestProto.TScenarioApplyRequest request = parseRequest(
                reqX, RequestProto.TScenarioApplyRequest.newBuilder(), RequestProto.TScenarioApplyRequest.class);
        logger.info("commitRequest: {}", serializeMessageJson(request));
        return AliceUtils.createSimpleTextResponse("Метод Commit не поддержан");
    }

    private String serializeMessageJson(Message request) {
        try {
            return JsonFormat.printer().print(request);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private void serializeResponse(HttpServletRequestX reqX, HttpServletResponseX respX, Message message) throws IOException {
        boolean json = "application/json".equals(reqX.getContentType());
        if (message != null) {
            if (json) {
                respX.writeContent(serializeMessageJson(message).getBytes(), "application/json");
            } else {
                respX.writeContent(message.toByteArray(), "application/protobuf");
            }
        }
        respX.flushBuffer();

        logger.debug("Result: {}", serializeMessageJson(message));
    }

    private Option<Long> extractUid(HttpServletRequestX reqX) {
        Option<CheckedUserTicket> userTicketO = reqX.getHeaderO(TvmHeaders.USER_TICKET).map(tvm2::checkUserTicket);
        if (userTicketO.isPresent()) {
            if (userTicketO.get().booleanValue()) {
                return Option.of(userTicketO.get().getDefaultUid());
            } else {
                throw new IncorrectTvmUserTicketException();
            }
        }
        return Option.empty();
    }
}
