package ru.yandex.chemodan.alice;

import ru.yandex.alice.megamind.protos.scenarios.ResponseProto;

/**
 * @author yashunsky
 */
public class AliceUtils {
    public static ResponseProto.TScenarioRunResponse createSimpleTextResponse(String response) {
        return ResponseProto.TScenarioRunResponse
                .newBuilder()
                .setResponseBody(ResponseProto.TScenarioResponseBody
                        .newBuilder()
                        .setLayout(ResponseProto.TLayout
                                .newBuilder()
                                .addCards(ResponseProto.TLayout.TCard
                                        .newBuilder()
                                        .setText(response)
                                )
                                .setOutputSpeech(response)
                        ))
                .build();
    }

    public static ResponseProto.TScenarioRunResponse irrelevantResponse() {
        return ResponseProto.TScenarioRunResponse.newBuilder().setFeatures(
                ResponseProto.TScenarioRunResponse.TFeatures.newBuilder().setIsIrrelevant(true).build()
        ).build();
    }
}
