package ru.yandex.chemodan.alice;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.logging.log4j.util.Strings;

import ru.yandex.alice.library.client.protos.ClientInfoProto;
import ru.yandex.bolts.collection.Option;

/**
 * temporary class while NAlice.ClientInfo does not fully support methods from
 * https://a.yandex-team.ru/arc/trunk/arcadia/alice/library/client/client_info.h
 * copy pasted from https://a.yandex-team.ru/arc/trunk/arcadia/alice/paskills/dialogovo/src/main/java/ru/yandex/alice/paskill/dialogovo/domain/ClientInfo.java
 * waiting for https://st.yandex-team.ru/MEGAMIND-838
 */
@AllArgsConstructor
@Data
public class ClientInfo {
    private final String appId;
    private final String appVersion;
    private final String platform;
    private final String osVersion;
    private final String uuid;
    private final Option<String> deviceId;
    private final String lang;
    private final String timezone;
    private final String deviceModel;
    private final String deviceManufacturer;

    public static ClientInfo fromProto(ClientInfoProto.TClientInfoProto proto) {
        return new ClientInfo(
                proto.getAppId(), proto.getAppVersion(), proto.getPlatform(), proto.getOsVersion(),
                proto.getUuid(), Option.ofNullable(proto.getDeviceId()), proto.getLang(), proto.getTimezone(),
                proto.getDeviceModel(), proto.getDeviceManufacturer());

    }

    private String trimToNone(String str) {
        return trimToValue(str, "none");
    }

    private String trimToValue(String str, String defaultValue) {
        str = Strings.trimToNull(str);
        str = "null".equals(str) ? null : str;
        return str != null ? str : defaultValue;
    }

    // https://wiki.yandex-team.ru/dialogs/development/station/#poleinterfaces
    // https://a.yandex-team.ru/arc/trunk/arcadia/alice/bass/forms/external_skill/ifs_map.cpp?rev=5559348#L20
    public boolean isHasScreenBASSimpl() {
        return !isSmartSpeaker() && !isElariWatch() && !isNavigator() && !isYaAuto();
    }

    public boolean isSupportsBilling() {
        return isSmartSpeaker() || isSearchApp();
    }

    public boolean isSupportsAccountLinking() {
        return isSmartSpeaker() || isSearchApp() || isYaBrowserMobile();
    }

    public boolean isChatBot() {
        return "telegram".equals(appId);
    }

    public boolean isAndroid() {
        return ("android".equals(platform) && !isQuasar());
    }

    public boolean isIOS() {
        return "ios".equals(platform) ||
                "ipad".equals(platform) ||
                "iphone".equals(platform);
    }

    public boolean isWindows() {
        return "windows".equals(platform);
    }

    public boolean isLinux() {
        return "linux".equals(platform);
    }

    public boolean isTestClient() {
        return appId != null && (
                appId.equals("uniproxy.monitoring") ||
                        appId.equals("uniproxy.test") ||
                        appId.equals("com.yandex.search.shooting") ||
                        appId.equals("test") ||
                        appId.startsWith("com.yandex.vins"));
    }

    public boolean isQuasar() {
        return appId != null && appId.startsWith("ru.yandex.quasar");
    }

    public boolean isMiniSpeaker() {
        return appId != null && appId.startsWith("aliced");
    }

    public boolean isSmartSpeaker() {
        return isQuasar() || isMiniSpeaker() || isStationMini();
    }

    public boolean isTvDevice() {
        return appId != null && appId.equals("com.yandex.tv.alice");
    }

    public boolean isTestSmartSpeaker() {
        return isSmartSpeaker() && appId != null && appId.endsWith("vins_test");
    }

    public boolean isTouch() {
        return isAndroid() || isIOS() || isTestClient();
    }

    public boolean isDesktop() {
        return isYaStroka() || isYaBrowserDesktop();
    }

    public boolean isSearchAppTest() {
        return "ru.yandex.mobile.inhouse".equals(appId) ||
                "ru.yandex.mobile.dev".equals(appId) ||
                (appId != null && appId.startsWith("ru.yandex.searchplugin.")) ||
                isWeatherPluginTest();
    }

    public boolean isSearchAppProd() {
        return "ru.yandex.mobile".equals(appId) ||
                "ru.yandex.searchplugin".equals(appId) ||
                isWeatherPluginProd();
    }

    public boolean isSearchApp() {
        return isSearchAppProd() ||
                isSearchAppTest() ||
                isWeatherPlugin() || // absorbed client: DIALOG-5251
                isTestClient() || // assume that all test clients are "Search app"
                isSampleApp();
    }

    public boolean isWeatherPluginTest() {
        return appId != null && appId.startsWith("ru.yandex.weatherplugin.");
    }

    public boolean isWeatherPluginProd() {
        return "ru.yandex.weatherplugin".equals(appId);
    }

    public boolean isWeatherPlugin() {
        return isWeatherPluginTest() || isWeatherPluginProd();
    }

    public boolean isAliceKit() {
        return appId != null && (appId.startsWith("ru.yandex.mobile.alice") ||
                appId.startsWith("com.yandex.alicekit"));
    }

    public boolean isAliceKitDemo() {
        return appId != null && appId.startsWith("com.yandex.alicekit.demo");
    }

    public boolean isSampleApp() {
        return "com.yandex.dialog_assistant.sample".equals(appId) ||
                "ru.yandex.mobile.search.dialog_assistant_sample".equals(appId) ||
                isYaBrowserIpadTest() ||
                isAliceKit();
    }

    public boolean isYaStroka() {
        return "winsearchbar".equals(appId);
    }

    public boolean isYaBrowserIpadTest() {
        return "ru.yandex.mobile.search.ipad.inhouse".equals(appId) ||
                "ru.yandex.mobile.search.ipad.dev".equals(appId) ||
                "ru.yandex.mobile.search.ipad.test".equals(appId);
    }

    public boolean isYaBrowserIpadProd() {
        return "ru.yandex.mobile.search.ipad".equals(appId);
    }

    public boolean isYaBrowserIpad() {
        return isYaBrowserIpadTest() ||
                isYaBrowserIpadProd();
    }

    public boolean isYaBrowserTest() {
        return isYaBrowserTestDesktop() || isYaBrowserTestMobile();
    }

    public boolean isYaBrowserTestDesktop() {
        return "yabro.beta".equals(appId) ||
                "yabro.broteam".equals(appId) ||
                "yabro.canary".equals(appId) ||
                "yabro.dev".equals(appId)
                ;
    }

    public boolean isYaBrowserTestMobile() {
        return (
                // iOS
                "ru.yandex.mobile.search.inhouse".equals(appId) ||
                        "ru.yandex.mobile.search.dev".equals(appId) ||
                        "ru.yandex.mobile.search.test".equals(appId) ||
                        // Android
                        "com.yandex.browser.beta".equals(appId) ||
                        "com.yandex.browser.alpha".equals(appId) ||
                        "com.yandex.browser.inhouse".equals(appId) || // TODO: remove (ask gump@)
                        "com.yandex.browser.dev".equals(appId) || // TODO: remove (ask gump@)
                        "com.yandex.browser.canary".equals(appId) ||
                        "com.yandex.browser.broteam".equals(appId)
        );
    }

    public boolean isYaBrowserCanary() {
        return isYaBrowserCanaryDesktop() || isYaBrowserCanaryMobile();
    }

    public boolean isYaBrowserCanaryDesktop() {
        return "yabro.canary".equals(appId);
    }

    public boolean isYaBrowserCanaryMobile() {
        return "com.yandex.browser.canary".equals(appId);
    }

    public boolean isYaBrowserProd() {
        return isYaBrowserProdDesktop() || isYaBrowserProdMobile();
    }

    public boolean isYaBrowserProdDesktop() {
        return "yabro".equals(appId) || "YaBro.beta".equals(appId) || "YaBro".equals(appId);
    }

    public boolean isYaBrowserProdMobile() {
        return "ru.yandex.mobile.search".equals(appId) ||
                "com.yandex.browser".equals(appId);
    }

    public boolean isYaBrowser() {
        return isYaBrowserTest() ||
                isYaBrowserProd();
    }

    public boolean isYaBrowserDesktop() {
        return (
                isYaBrowserTestDesktop() ||
                        isYaBrowserCanaryDesktop() ||
                        isYaBrowserProdDesktop()
        );
    }

    public boolean isYaBrowserMobile() {
        return (
                isYaBrowserIpad() ||
                        isYaBrowserTestMobile() ||
                        isYaBrowserCanaryMobile() ||
                        isYaBrowserProdMobile()
        );
    }

    public boolean isYaLeftScreen() {
        return appId != null && appId.startsWith("ru.yandex.leftscreen"); // Android
    }

    public boolean isYaLauncher() {
        return appId != null && appId.startsWith("com.yandex.launcher"); // Android
    }

    public boolean isNavigator() {
        return appId != null && (appId.startsWith("ru.yandex.mobile.navigator") ||
                appId.startsWith("ru.yandex.yandexnavi"));
    }

    public boolean isNavigatorBeta() {
        return "ru.yandex.mobile.navigator.inhouse".equals(appId) ||
                "ru.yandex.mobile.navigator.sandbox".equals(appId) ||
                "ru.yandex.yandexnavi.inhouse".equals(appId) ||
                "ru.yandex.yandexnavi.sandbox".equals(appId);
    }

    public boolean isYaAuto() {
        return appId != null && appId.startsWith("yandex.auto");
    }

    public boolean isClientWithNavigator() {
        return isNavigator() ||
                isYaAuto();
    }

    public boolean isPpBeta() {
        return "ru.yandex.searchplugin.beta".equals(appId) ||
                "ru.yandex.searchplugin.dev".equals(appId);
    }

    public boolean isPpNightly() {
        return "ru.yandex.searchplugin.nightly".equals(appId);
    }

    public boolean isElariWatch() {
        return appId != null && appId.startsWith("ru.yandex.iosdk.elariwatch");
    }

    public boolean isYaMessenger() {
        return "ru.yandex.messenger".equals(appId);
    }

    public boolean isYaMusicTest() {
        return appId != null && appId.startsWith("ns.mobile.music");
    }

    public boolean isYaMusicProd() {
        return appId != null && (appId.startsWith("ru.yandex.mobile.music") ||
                appId.startsWith("ru.yandex.music"));
    }

    public boolean isYaMusic() {
        return isYaMusicTest() || isYaMusicProd();
    }

    public boolean isDevConsole() {
        return uuid != null && uuid.startsWith("dev-console");
    }

    public boolean isStationMini() {
        return "Yandex".equals(deviceManufacturer) && "yandexmini".equals(deviceModel);
    }
}
