package ru.yandex.chemodan.bazinga;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.actor.typed.dynamic.DynamicConfigurationTypedServer;
import ru.yandex.commune.bazinga.BazingaActorServerHolder;
import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.misc.ip.InternetDomainName;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author dbrylev
 */
@Configuration
public class BazingaConfigurationContextConfiguration {

    @Value("${bazinga.port:-28702}")
    private IpPort bazingaPort;

    @Bean
    public DynamicConfigurationTypedServer typedServer() {
        return new DynamicConfigurationTypedServer(bazingaPort);
    }

    @Bean
    public BazingaActorServerHolder bazingaActorServerHolder(DynamicConfigurationTypedServer typedServer) {
        return new BazingaActorServerHolder(typedServer);
    }

    @Bean
    public BazingaConfiguration bazingaConfiguration(@Qualifier("zkBazingaRoot") ZkPath root) {
        return new BazingaConfiguration(root, new InternetDomainName(HostnameUtils.localHostname()), bazingaPort);
    }
}
