package ru.yandex.chemodan.bazinga;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.bazinga.impl.controller.BazingaControllerConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaConfigurationContextConfiguration.class,
})
public class BazingaControllerConfigurationContextConfiguration {

    @Bean
    public BazingaControllerConfiguration bazingaControllerConfiguration(
            @Value("${bazinga.controller.poll.delay}") Duration pollDelay,
            @Value("${bazinga.controller.gc.delay}") Duration gcDelay)
    {
        return new BazingaControllerConfiguration(pollDelay, gcDelay);
    }
}
