package ru.yandex.chemodan.bazinga;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author dbrylev
 */
public class BazingaWorkerTaskQueues {
    public final Option<TaskQueueName> cronQueue;
    public final Option<TaskQueueName> regularQueue;
    public final Option<TaskQueueName> cpuIntensiveQueue;

    public final ListF<TaskQueue> specificQueues;

    public BazingaWorkerTaskQueues(
            TaskQueueName cronQueue,
            TaskQueueName regularQueue,
            TaskQueueName cpuIntensiveQueue,
            ListF<TaskQueue> specificQueues)
    {
        this(Option.of(cronQueue), Option.of(regularQueue), Option.of(cpuIntensiveQueue), specificQueues);
    }

    public BazingaWorkerTaskQueues(
            Option<TaskQueueName> cronQueue,
            Option<TaskQueueName> regularQueue,
            Option<TaskQueueName> cpuIntensiveQueue,
            ListF<TaskQueue> specificQueues)
    {
        this.cronQueue = cronQueue;
        this.regularQueue = regularQueue;
        this.cpuIntensiveQueue = cpuIntensiveQueue;
        this.specificQueues = specificQueues;
    }
}
