package ru.yandex.chemodan.bazinga;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.commune.alive2.location.ConductorYpQloudLocationResolver;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.alive2.location.LocationType;
import ru.yandex.commune.bazinga.admin.BazingaAdminAddressResolver;
import ru.yandex.commune.bazinga.impl.worker.BazingaHostPort;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author dbrylev
 */
public class CompoundBazingaAdminAddressResolver implements BazingaAdminAddressResolver {

    private final LocationResolver locationResolver;
    private final String yaTeamProxyHost;
    private final App controllerApp;
    private final ListF<App> workerApps;

    public CompoundBazingaAdminAddressResolver(LocationResolver locationResolver, String yaTeamProxyHost,
                                               App controllerApp, ListF<App> workerApps) {
        this.locationResolver = locationResolver;
        this.yaTeamProxyHost = yaTeamProxyHost;
        this.controllerApp = controllerApp;
        this.workerApps = workerApps;
    }

    @Override
    public String zUrlForController(BazingaHostPort hostPort) {
        return urlBase(hostPort) + "/z/";
    }

    @Override
    public String urlForLogs(BazingaHostPort hostPort) {
        return urlBase(hostPort) + "/bazinga/";
    }

    private String urlBase(BazingaHostPort hostPort) {
        LocationType locationType = locationResolver.resolveLocationFor(Option.of(hostPort.getHost())).getLocationType();
        if (yaTeamProxyHost.isEmpty() || !locationType.isCloud()) {
            return workerApps.find(app -> app.matches(hostPort)).orElse(controllerApp).urlBase(hostPort);
        } else {
            return "https://" + getCloudUrl(hostPort.getHost(), locationType) + '.' + yaTeamProxyHost;
        }
    }

    private String getCloudUrl(String host, LocationType locationType) {
        if (locationType == LocationType.QLOUD) {
            return StringUtils.substringBefore(host, ConductorYpQloudLocationResolver.QLOUD_SUFFIX);
        } else if (locationType == LocationType.YP) {
            return StringUtils.substringBefore(host, ConductorYpQloudLocationResolver.YP_SUFFIX).replace('.', '-');
        }

        return host;
    }

    public static class App {
        private final String urlPrefix;
        private final Function1B<String> hostnameMatcher;

        public App(String urlHostPrefix, Function1B<String> hostnameMatcher) {
            this.urlPrefix = "http://" + urlHostPrefix;
            this.hostnameMatcher = hostnameMatcher;
        }

        private boolean matches(BazingaHostPort hostPort) {
            return hostnameMatcher.apply(hostPort.getHost());
        }

        private String urlBase(BazingaHostPort hostPort) {
            return urlPrefix + hostPort.getHost() + ":81";
        }
    }
}
