package ru.yandex.chemodan.bazinga;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.bazinga.CompoundBazingaAdminAddressResolver.App;
import ru.yandex.chemodan.util.DiskHostnameUtils;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.alive2.location.LocationResolverConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import(LocationResolverConfiguration.class)
public class CompoundBazingaAdminAddressResolverContextConfiguration {

    @Bean
    public CompoundBazingaAdminAddressResolver bazingaAdminAddressResolver(
            LocationResolver locationResolver,
            @Value("${admin.yateam.proxy.host}") String yaTeamProxyHost) {
        return new CompoundBazingaAdminAddressResolver(
                locationResolver,
                yaTeamProxyHost,
                new App("", host -> !DiskHostnameUtils.isDisk(host)),
                Cf.list(
                        new App("smartcache-worker.", host -> host.startsWith("smartcache-worker")),
                        new App("dataapi-dataapi-worker.", host -> host.startsWith("dataapi-worker")))
        );
    }
}
