package ru.yandex.chemodan.bazinga;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.chemodan.util.DiskHostnameUtils;
import ru.yandex.chemodan.util.test.AbstractTest;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.bazinga.impl.worker.BazingaHostPort;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.property.eval.PropertyPlaceholderConfigurer2;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = CompoundBazingaAdminAddressResolverTest.Configuration.class)
public class CompoundBazingaAdminAddressResolverTest extends AbstractTest {

    @Autowired
    private CompoundBazingaAdminAddressResolver resolver;

    @Autowired
    private LocationResolver locationResolver;

    static {
        TestHelper.initialize();
    }

    @Test
    public void resolve() {
        Assert.equals("http://sas1-1c1f7f14a1d2.qloud-c.yandex.net:81/z/",
                resolver.zUrlForController(new BazingaHostPort("sas1-1c1f7f14a1d2.qloud-c.yandex.net", 28702)));

        Assert.equals("http://oh3lqauy4t2uff5t.sas.yp-c.yandex.net:81/z/",
                resolver.zUrlForController(new BazingaHostPort("oh3lqauy4t2uff5t.sas.yp-c.yandex.net", 28702)));

        Assert.equals("http://dataapi-dataapi-worker.dataapi-worker01f.disk.yandex.net:81/z/",
                resolver.zUrlForController(new BazingaHostPort("dataapi-worker01f.disk.yandex.net", 28702)));
    }

    @Test
    public void resolveWithProxy() {
        CompoundBazingaAdminAddressResolver resolver = new CompoundBazingaAdminAddressResolver(
                locationResolver,
                "admin.disk.yandex-team.ru",
                new CompoundBazingaAdminAddressResolver.App("", host -> !DiskHostnameUtils.isDisk(host)),
                Cf.list()
        );

        Assert.equals("https://sas1-1c1f7f14a1d2.admin.disk.yandex-team.ru/z/",
                resolver.zUrlForController(new BazingaHostPort("sas1-1c1f7f14a1d2.qloud-c.yandex.net", 28702)));

        Assert.equals("https://oh3lqauy4t2uff5t-sas.admin.disk.yandex-team.ru/z/",
                resolver.zUrlForController(new BazingaHostPort("oh3lqauy4t2uff5t.sas.yp-c.yandex.net", 28702)));

        Assert.equals("https://sas1-1c1f7f14a1d2.admin.disk.yandex-team.ru/bazinga/",
                resolver.urlForLogs(new BazingaHostPort("sas1-1c1f7f14a1d2.qloud-c.yandex.net", 28702)));
    }

    @Import(CompoundBazingaAdminAddressResolverContextConfiguration.class)
    static class Configuration {
        @Bean
        public static PropertyPlaceholderConfigurer2 propertyPlaceholderConfigurer2() {
            final PropertyPlaceholderConfigurer2 configurer2 = new PropertyPlaceholderConfigurer2();
            configurer2.setProperties(PropertiesHolder.properties());
            return configurer2;
        }
    }
}
