package ru.yandex.chemodan.bazinga;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskCategory;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.WorkerChooserName;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.misc.jvm.JavaOptions;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author dbrylev
 */
public class CronTaskWrapper extends CronTask {

    private final CronTask task;

    public CronTaskWrapper(CronTask task) {
        this.task = task;
    }

    @Override
    public TaskId id() {
        return task.id();
    }

    @Override
    public TaskQueueName queueName() {
        return task.queueName();
    }

    @Override
    public Duration timeout() {
        return task.timeout();
    }

    @Override
    public WorkerChooserName workerChooserName() {
        return task.workerChooserName();
    }

    @SuppressWarnings("unchecked")
    private static final Function<CronTask, Option<JavaOptions>> createForkedTaskOptions =
            ClassX.getDeclaredMethod(CronTask.class, "createForkedTaskOptions").toSam(Function.class);

    @Override
    protected Option<JavaOptions> createForkedTaskOptions() {
        return createForkedTaskOptions.apply(task);
    }

    @Override
    public float requiredProcessors() {
        return task.requiredProcessors();
    }

    @Override
    public TaskCategory getTaskCategory() {
        return task.getTaskCategory();
    }

    @Override
    public Schedule cronExpression() {
        return task.cronExpression();
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        task.execute(executionContext);
    }
}
