package ru.yandex.chemodan.bazinga;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.test.ConditionalOnMissingEmbeddedBazingaDb;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author vpronto
 */
@Configuration
@ConditionalOnMissingEmbeddedBazingaDb
public class DataSourceBazingaStorageContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    @OverridableValuePrefix("bazinga")
    public DataSourceProperties bazingaDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    public JdbcDatabaseConfigurator bazingaDbConfigurator(
            @Value("${bazinga.zk.enabled}")
            boolean useZkRegistry,
            DataSourceProperties bazingaDataSourceProperties,
            ZkShardSource shardSource)
    {
        if (useZkRegistry) {
            return dbConfiguratorConfig.consDynamicJdbcConfigurator(bazingaDataSourceProperties, shardSource);
        } else {
            return dbConfiguratorConfig.consJdbcConfigurator(bazingaDataSourceProperties);
        }
    }

    @Bean
    public ZkShardSource zkShardSource(
            @Value("${bazinga.zk.registry.path}")
            String path,
            @Qualifier("zkAllRoot")
            ZkPath zkAllRoot,
            ZkManager zkManager)
    {
        ZkShardSource shardSource = new ZkShardSource(zkAllRoot.child(path));
        zkManager.addClient(shardSource);
        return shardSource;
    }
}


