package ru.yandex.chemodan.bazinga;

import org.joda.time.Duration;

import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.pg.storage.maintenance.TaskCleanupSettings;
import ru.yandex.commune.bazinga.pg.storage.maintenance.TaskCleanupSettingsProvider;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;

/**
 * @author yashunsky
 */
public class JobsCleaningRegistry extends ZkRegistry<TaskId, TaskCleanupSettings> implements TaskCleanupSettingsProvider {
    public static final TaskId DEFAULT_SETUP_NAME = new TaskId("default");

    public JobsCleaningRegistry(ZkPath path) {
        super(path, BazingaBender.mapper.createParserSerializer(TaskCleanupSettings.class), t -> t.id, TaskId::getId);
    }

    @Override
    public TaskCleanupSettings get(TaskId taskId) {
        return getO(taskId).orElse(() -> getO(DEFAULT_SETUP_NAME)).getOrElse(() -> getEmpty(taskId));
    }

    public TaskCleanupSettings getEmpty(TaskId id) {
        return new TaskCleanupSettings(id, Duration.standardDays(365), Duration.standardDays(365));
    }
}
