package ru.yandex.chemodan.bazinga;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author dbrylev
 */
@Configuration
public class JobsCleaningRegistryContextConfiguration {

    @Bean
    public JobsCleaningRegistry jobsCleaningRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        JobsCleaningRegistry registry = new JobsCleaningRegistry(zkRoot.child("jobs-cleaning"));

        zkManager.addClient(registry);
        return registry;
    }
}
