package ru.yandex.chemodan.bazinga;

import java.util.Optional;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.bazinga.impl.worker.BazingaHostPort;
import ru.yandex.commune.bazinga.pg.fetcher.FetchLimits;
import ru.yandex.commune.bazinga.pg.fetcher.PgBazingaJobsFetcherConfiguration;
import ru.yandex.commune.dynproperties.DynamicProperty;

/**
 * @author dbrylev
 */
@Configuration
public class PgBazingaFetcherConfigurationContextConfiguration {

    private final DynamicProperty<Integer> totalLimit =
            new DynamicProperty<>("bazinga.jobs-fetcher.limits.total", 1000);

    private final DynamicProperty<Integer> taskMinimumLimit =
            new DynamicProperty<>("bazinga.jobs-fetcher.limits.task-minimum", 100);

    @Bean
    public PgBazingaJobsFetcherConfiguration bazingaJobsFetcherConfiguration(
            Optional<BazingaConfiguration> configuration,
            Optional<BazingaHostPort> hostPort,
            @Value("${bazinga.controller.poll.delay}") Duration pollDelay,
            @Value("${bazinga.pg.fetch.threads}") int threads,
            @Value("${bazinga.pg.fetch.thread-by-shard}") boolean threadByShard,
            @Value("${bazinga.pg.fetch.thread-update-ttl}") long threadUpdateTtl)
    {
        BazingaHostPort workerId = hostPort.orElseGet(configuration.map(BazingaConfiguration::getHostPort)::get);

        return new PgBazingaJobsFetcherConfiguration(
                workerId, pollDelay, threads,
                () -> new FetchLimits(taskMinimumLimit.get(), totalLimit.get()), threadByShard, threadUpdateTtl);
    }
}
