package ru.yandex.chemodan.bazinga;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.bazinga.impl.FullJobId;
import ru.yandex.commune.bazinga.impl.JobId;
import ru.yandex.commune.bazinga.impl.JobInfoValue;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.impl.OnetimeUtils;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;

/**
 * @author dbrylev
 */
public class PgOnetimeUtils {

    @SuppressWarnings("unchecked")
    public static <T> T parseParameters(OnetimeTaskSupport<T> task, String parameters) {
        return (T) OnetimeUtils.parseParameters(task, parameters);
    }

    public static String getActiveUniqueIdentifier(OnetimeTask task) {
        return OnetimeUtils.getActiveUniqueIdentifier(task);
    }

    public static OnetimeJob makeJob(OnetimeTask task, Instant scheduleTime) {
        return makeJob(task, scheduleTime, getActiveUniqueIdentifier(task), task.priority());
    }

    public static OnetimeJob makeJob(
            OnetimeTask task, Instant scheduleTime, String activeUid, int priority)
    {
        return makeJob(task, scheduleTime, Option.of(activeUid), priority);
    }

    public static OnetimeJob makeJob(
        OnetimeTask task, Instant scheduleTime, Option<String> activeUid, int priority)
    {
        return new OnetimeJob(
            new FullJobId(task.id(), new JobId(UUID.randomUUID())),
            Option.of(Instant.now()),
            scheduleTime,
            activeUid,
            new String(BazingaBender.mapper.serializeJson(task.getParameters())),
            JobInfoValue.ready(),
            Option.empty(), Cf.set(), Option.empty(),
            priority,
            Option.empty());
    }
}
