package ru.yandex.chemodan.bazinga;

import ru.yandex.commune.bazinga.impl.CronTaskState;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.impl.WorkerState;
import ru.yandex.commune.bazinga.impl.controller.ControllerInternalApi;
import ru.yandex.commune.bazinga.impl.worker.WorkerInfo;

/**
 * @author dbrylev
 */
public class UntraceableTasksControllerApi implements ControllerInternalApi {

    private final ControllerInternalApi target;
    private final UntraceableTasks tasks;

    public UntraceableTasksControllerApi(ControllerInternalApi target, UntraceableTasks tasks) {
        this.target = target;
        this.tasks = tasks;
    }

    @Override
    public void jobStatusChanged(CronTaskState state) {
        target.jobStatusChanged(state);
    }

    @Override
    public void jobStatusChanged(OnetimeJob job) {
        if (tasks.shouldTrace(job)) {
            target.jobStatusChanged(job);
        }
    }

    @Override
    public void sendState(WorkerState workerState) {
        target.sendState(workerState);
    }

    @Override
    public void workerInfoChanged(WorkerInfo newInfo) {
        target.workerInfoChanged(newInfo);
    }
}
