package ru.yandex.chemodan.bazinga;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.misc.support.tl.ThreadLocalHandle;

/**
 * @author akirakozov
 */
public abstract class YcridOnetimeTaskSupport<T extends YcridTaskParameters> extends OnetimeTaskSupport<T> {

    protected YcridOnetimeTaskSupport(T parameters) {
        super(parameters);
    }

    protected YcridOnetimeTaskSupport(Class<T> parametersClass) {
        super(parametersClass);
    }

    @Override
    protected void execute(T parameters, ExecutionContext context) throws Exception {
        Option<ThreadLocalHandle> handler = parameters.ycrid.map(YandexCloudRequestIdHolder::setAndPushToNdc);
        try {
            doExecute(parameters, context);
        } finally {
            handler.forEach(ThreadLocalHandle::popSafely);
        }
    }

    protected abstract void doExecute(T parameters, ExecutionContext context);

    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return YcridTaskParametersConverter.class;
    }

}
