package ru.yandex.chemodan.bazinga;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.util.ReflectionUtils;
import ru.yandex.commune.bazinga.MapWrapper;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;

/**
 * @author friendlyevil
 */
public class YcridTaskParametersConverter implements ActiveUniqueIdentifierConverter<YcridTaskParameters, MapWrapper> {
    @Override
    public Class<MapWrapper> getActiveUniqueIdentifierClass() {
        return MapWrapper.class;
    }

    protected SetF<String> getExcludedFields() {
        return Cf.set("ycrid");
    }

    @Override
    public MapWrapper convert(YcridTaskParameters parameters) {
        ListF<String> allFields = ReflectionUtils.getAllFieldNames(parameters.getClass());
        SetF<String> excludedFields = getExcludedFields();
        MapF<String, Object> map = Cf.hashMap();

        for (String filedName : allFields) {
            if (!excludedFields.containsTs(filedName)) {
                map.put(filedName, ReflectionUtils.getField(parameters, filedName));
            }
        }
        return new MapWrapper(map);
    }
}
