package ru.yandex.chemodan.bazinga;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.sharpei.ShardInfoSource;
import ru.yandex.commune.db.shard.ShardInfo;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.env.EnvironmentType;

/**
 * @author tolmalev
 */
public class ZkShardSource extends ZkRegistry<Integer, ZkShardSource.ZkShardInfo> implements ShardInfoSource {
    public ZkShardSource(ZkPath path) {
        super(path, Bender.cons(ZkShardSource.ZkShardInfo.class), info -> info.getId(), id -> Integer.toString(id));
    }

    @Override
    public ListF<ShardInfo> getShards() {
        CollectionF<ZkShardInfo> all = getAll();

        if (all.isEmpty() &&
                (EnvironmentType.getActive() == EnvironmentType.DEVELOPMENT
                        || EnvironmentType.getActive() == EnvironmentType.TESTING
                        || EnvironmentType.getActive() == EnvironmentType.TESTS))
        {
            // https://yc.yandex-team.ru/folders/foodqkuj4ge5j9sg34uq/managed-postgresql/cluster/mdbqtuaguaiudj0h2766
            ZkShardInfo stable1 = new ZkShardInfo(
                    1,
                    "qdb_stable1",
                    Cf.list(
                            "man-nulu663d40inz05e.db.yandex.net:6432/disk_test_qdb_stable1",
                            "sas-8y640j053450m9gx.db.yandex.net:6432/disk_test_qdb_stable1",
                            "vla-7obh57e630d1c255.db.yandex.net:6432/disk_test_qdb_stable1"
                    )
            );

            // https://yc.yandex-team.ru/folders/foodqkuj4ge5j9sg34uq/managed-postgresql/cluster/mdb5rg1qq712ojsv9ffe?section=databases
            ZkShardInfo stable2 = new ZkShardInfo(
                    2,
                    "qdb_stable2",
                    Cf.list(
                            "man-jss4xmf68e0tl9f2.db.yandex.net:6432/disk_test_qdb_stable2",
                            "sas-8ufd9gzwqpm5gklj.db.yandex.net:6432/disk_test_qdb_stable2",
                            "vla-tt8t3fsr8swzuney.db.yandex.net:6432/disk_test_qdb_stable2"
                    )
            );

            put(stable1);
            put(stable2);

            all = Cf.list(stable1, stable2);
        }

        return all.map(shard -> {
            ShardInfo info = new ShardInfo();

            info.setId(shard.getId());
            info.setName(shard.getName());

            info.setWriterHostPortDbname(shard.getHostPortDbNames().first());
            info.setReaderHostPortDbnames(shard.getHostPortDbNames());

            return info;
        });
    }

    @Data
    @BenderBindAllFields
    public static class ZkShardInfo {
        public final int id;
        public final String name;

        public final ListF<String> hostPortDbNames;
    }
}
