package ru.yandex.chemodan.bazinga.dynamic;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class DynamicCronTaskInfo extends DefaultObject {
    public final String id;
    public final String description;
    public final Duration timeout;
    public final String scriptText;
    public final ScheduleType scheduleType;
    public final String scheduleExpression;

    public final Option<String> queueName;

    public DynamicCronTaskInfo(
            String id, String description, Duration timeout, String scriptText,
            ScheduleType scheduleType,
            String scheduleExpression, Option<String> queueName)
    {
        this.id = id;
        this.description = description;
        this.timeout = timeout;
        this.scriptText = scriptText;
        this.scheduleType = scheduleType;
        this.scheduleExpression = scheduleExpression;
        this.queueName = queueName;
    }

    public enum ScheduleType {
        CRON,
        PERIOD
    }
}
