<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/jobs-cleaner/cleaning-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="dynamic-cron-task-info"/>
    </xsl:template>

    <xsl:template match="dynamic-cron-task-info">
        <div id="main-content">
        <div class="container">
        <h3>Edit task</h3>
        <form width="100%" method="POST" action="/z/dynamic-cron-tasks/save">
            <table border="0" width="100%">
                <tr>
                    <td width="10%">Task Id:</td>
                    <td>
                        <input name="id" type="text" class="form-control" value="{id}"/>
                    </td>
                </tr>
                <tr>
                    <td>Description:</td>
                    <td>
                        <input name="description" type="text" class="form-control" value="{description}"/>
                    </td>
                </tr>
                <tr>
                    <td>Timeout:</td>
                    <td>
                        <input name="timeout" type="text" class="form-control" value="{timeout}"/>
                    </td>
                </tr>
                <tr>
                    <td>Task queue:</td>
                    <td>
                        <input name="queueName" type="text" class="form-control" value="{queueName}"/>
                    </td>
                </tr>
                <tr>
                    <td>Shedule type:</td>
                    <td>
                        <select name="schedule-type">
                            <option>
                                <xsl:if test="schedule-type='cron'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                cron
                            </option>
                            <option>
                                <xsl:if test="schedule-type='period'">
                                    <xsl:attribute name="selected">selected</xsl:attribute>
                                </xsl:if>
                                period
                            </option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>Shedule expression:</td>
                    <td>
                        <input name="schedule-expression" type="text" class="form-control" value="{schedule-expression}"/>
                    </td>
                </tr>
                <tr>
                    <td>Script:</td>
                    <td>
                        <textarea name="scriptText" rows="20" class="form-control" value="{script-text}">
                            <xsl:value-of select="script-text"/>
                        </textarea>
                    </td>
                </tr>
            </table>
            <button type="submit" class="btn btn-success">Save</button>
        </form>
        <div class="info">
            <h4>Supported TTL formats</h4>
            <ul>
                <li>
                    <i>"10", "10.0" or "10s"</i>
                    - 10 seconds
                </li>
                <li>
                    <i>"11:22:33"</i>
                    - 11 hours, 22 minutes, 33 seconds
                </li>
                <li>
                    <i>"44 days"</i>
                    - 44 days
                </li>
                <li>
                    <i>"5h"</i>
                    - 5 hours
                </li>
                <li>
                    <i>"6m"</i>
                    - 6 minutes
                </li>
            </ul>
        </div>
        </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
