<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/jobs-cleaner/cleaning-edit.js"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <h3>Dynamic cron tasks</h3>
        <table class="table table-striped table-condensed table-bordered">
            <tr>
                <th>id</th>
                <th>description</th>
                <th>schedule</th>
            </tr>
            <xsl:for-each select="tasks">
                <tr>
                    <td>
                        <a href="/z/dynamic-cron-tasks/edit?id={id}"><xsl:value-of select="id"/></a>
                    </td>
                    <td>
                        <xsl:value-of select="description"/>
                    </td>
                    <td>
                        <xsl:value-of select="schedule-type"/>
                        <xsl:value-of select="schedule-expression"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <xsl:apply-templates select="." mode="modal-edit-form"/>
    </xsl:template>

    <xsl:include href="classpath:ru/yandex/chemodan/admin/common/modal-edit-form.xsl"/>

    <xsl:template match="content" mode="modal-edit-form">
        <xsl:call-template name="modal-edit-form">
            <xsl:with-param name="id" select="'cleaning-edit'"/>
            <xsl:with-param name="size" select="'s'"/>

            <xsl:with-param name="content">
                <xsl:apply-templates select="." mode="edit-form"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="content" mode="edit-form">
        <form class="edit-form">
            <dl class="dl-horizontal">
                <dt>Task Id</dt>
                <dd>
                    <div class="form-group">
                        <input name="id" type="text" class="form-control"/>
                    </div>
                </dd>
                <dt>TTL for completed tasks</dt>
                <dd>
                    <div class="form-group">
                        <input name="completedTtl" type="text" class="form-control"/>
                    </div>
                </dd>
                <dt>TTL for failed tasks</dt>
                <dd>
                    <div class="form-group">
                        <input name="failedTtl" type="text" class="form-control"/>
                    </div>
                </dd>
            </dl>
        </form>
        <div class="info">
            <h4>Supported TTL formats</h4>
            <ul>
                <li>
                    <i>"10", "10.0" or "10s"</i>
                    - 10 seconds
                </li>
                <li>
                    <i>"11:22:33"</i>
                    - 11 hours, 22 minutes, 33 seconds
                </li>
                <li>
                    <i>"44 days"</i>
                    - 44 days
                </li>
                <li>
                    <i>"5h"</i>
                    - 5 hours
                </li>
                <li>
                    <i>"6m"</i>
                    - 6 minutes
                </li>
            </ul>
        </div>

    </xsl:template>

</xsl:stylesheet>
