package ru.yandex.chemodan.bazinga.dynamic;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.bender.HumanReadableDurationUnmarshaller;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.EmptyContentPojo;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class DynamicCronTasksAdminPage {

    private final DynamicCronTasksManager dynamicCronTasksManager;

    public DynamicCronTasksAdminPage(DynamicCronTasksManager dynamicCronTasksManager) {
        this.dynamicCronTasksManager = dynamicCronTasksManager;
    }

    @ZAction(defaultAction = true)
    @Path("/dynamic-cron-tasks")
    public ListDynamicTasks index() {
        return new ListDynamicTasks(dynamicCronTasksManager.listDynamicCronTasks());
    }

    @ZAction
    @Path("/dynamic-cron-tasks/edit")
    public DynamicCronTaskInfo editTask(@RequestParam("id") String id) {
        return dynamicCronTasksManager.listDynamicCronTasks()
                .find(task -> task.id.equals(id))
                .getOrElse(new DynamicCronTaskInfo(
                        id,
                        "Create new task",
                        Duration.standardMinutes(5),
                        "print('Hello!!!')",
                        DynamicCronTaskInfo.ScheduleType.PERIOD,
                        "60",
                        Option.of("cron"))
        );
    }

    @Path(value = "/dynamic-cron-tasks/save", methods = HttpMethod.POST)
    public EmptyContentPojo saveTask(
            @RequestParam("id")
            String id,
            @RequestParam("description")
            String description,
            @RequestParam("timeout")
            String timeoutRaw,
            @RequestParam("scriptText")
            String scriptText,
            @RequestParam("scheduleType")
            DynamicCronTaskInfo.ScheduleType scheduleType,
            @RequestParam("scheduleExpression")
            String scheduleExpression,
            @RequestParam("queueName")
            String queueName)
    {
        queueName = Option.ofNullable(StringUtils.trimToNull(queueName)).getOrElse("cron");

        Duration timeout = (Duration) new HumanReadableDurationUnmarshaller().convert(timeoutRaw);
        dynamicCronTasksManager.save(new DynamicCronTaskInfo(id, description, timeout, scriptText, scheduleType, scheduleExpression, Option.of(queueName)));
        throw new ZRedirectException("/dynamic-cron-tasks/edit?id=" + UrlUtils.urlEncode(id));
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    private static final class ListDynamicTasks {
        public final ListF<DynamicCronTaskInfo> tasks;

        private ListDynamicTasks(ListF<DynamicCronTaskInfo> tasks) {
            this.tasks = tasks;
        }
    }
}
