package ru.yandex.chemodan.bazinga.dynamic;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.commune.bazinga.BazingaWorkerApp;
import ru.yandex.commune.util.serialize.ToMultilineSerializer;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 */
@Configuration
public class DynamicCronTasksContextConfiguration {

    @Bean
    public DynamicCronTasksManager dynamicCronTasksManager(
            ZkManager zkManager,
            @Qualifier("zkRoot")
            ZkPath zkRoot,
            BazingaWorkerTaskQueues workerTaskQueues,
            BazingaWorkerApp bazingaWorkerApp,
            ApplicationContext applicationContext,
            ToMultilineSerializer toMultilineSerializer)
    {
        DynamicCronTasksManager manager = new DynamicCronTasksManager(
                zkRoot.child("dynamic_cron_tasks"),
                bazingaWorkerApp,
                workerTaskQueues.cronQueue.getOrThrow("Cron task queue was not specified"),
                applicationContext,
                toMultilineSerializer);

        zkManager.addClient(manager);

        return manager;
    }
}
