package ru.yandex.chemodan.bazinga.http;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.ip.HostPort;

/**
 * @author dbrylev
 */
@Configuration
public class PgHttpBazingaClientContextConfiguration {

    @Bean
    public PgHttpBazingaTaskManager bazingaTaskManager(@Value("${worker2.api.hostPort}") HostPort hostPort) {
        HttpClient httpClient = pworkerHttpClientConfigurator().configure();

        return new PgHttpBazingaTaskManager(hostPort, httpClient);
    }

    @Bean
    @OverridableValuePrefix("pworker")
    public HttpClientConfigurator pworkerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
