package ru.yandex.chemodan.bazinga.http;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.DefaultActionConfiguration;
import ru.yandex.commune.a3.action.parameter.bind.BenderParameterBinder;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ResultSerializer;
import ru.yandex.commune.a3.action.result.SimpleResultSerializer;
import ru.yandex.commune.a3.action.result.json.JsonResultSerializer;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author dbrylev
 */
public class PgTasksActionConfigurator {

    public static final BenderMapper benderMapper = CeleryBender.mapper;

    public static ActionApp configure(ApplicationInfo applicationInfo, ListF<Object> actions) {
        return ActionConfigurator.configure(actions,
                DefaultActionConfiguration.defaultConfiguration(applicationInfo)
                        .setResultSerializers(Cf.<ResultSerializer<?>>list(
                                new SimpleResultSerializer(),
                                new JsonResultSerializer(),
                                new JsonPojoResultSerializer(benderMapper)))
                        .setInvocationInterceptors(Cf.list(
                                new AddCommonAttributesInterceptor(applicationInfo)))
                        .setParameterBinders(Cf.list(new BenderParameterBinder(benderMapper)))
                        .setResultType(MediaType.APPLICATION_JSON)
        );
    }
}
