package ru.yandex.chemodan.notifier;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.http.YandexCloudRequestIdHolder;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * This task do nothing, just hang up in worker to avoid creation
 * a lot of add lenta blocks in one moment.
 * @author akirakozov
 */
public class AddLentaNotificationBlockerTask extends YcridOnetimeTaskSupport<AddLentaNotificationBlockTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(AddLentaNotificationBlockTask.class);

    protected AddLentaNotificationBlockerTask(AddLentaNotificationBlockTask.Parameters parameters) {
        super(parameters);
    }

    public AddLentaNotificationBlockerTask() {
        super(AddLentaNotificationBlockTask.Parameters.class);
    }

    public AddLentaNotificationBlockerTask(DataApiUserId uid, String blockId) {
        this(new AddLentaNotificationBlockTask.Parameters(
                uid, blockId, YandexCloudRequestIdHolder.getO(), Option.empty(), Option.empty()));
    }

    @Override
    protected void doExecute(AddLentaNotificationBlockTask.Parameters parameters, ExecutionContext context) {
        logger.debug("Release lock for new block creation: uid {}, blockId {}",
                parameters.activeUid.uid, parameters.activeUid.blockId);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardSeconds(5);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Override
    public TaskQueueName queueName() {
        return NotificationTaskQueueName.NOTIFIER_REGULAR;
    }

    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return AddLentaNotificationBlockTask.ActiveUidParams.Converter.class;
    }
}
