package ru.yandex.chemodan.queller.admin;

import java.util.function.Supplier;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.admin.common.CommonLocator;
import ru.yandex.chemodan.admin.lib.LibLocator;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.queller.celery.worker.WorkerStateProviderHolder;
import ru.yandex.chemodan.queller.rabbit.RabbitPool;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorGroup;
import ru.yandex.misc.ip.InternetDomainName;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author dbrylev
 */
@Configuration
public class CeleryMonitorAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @PostConstruct
    public void init() {
        adminApp.registerHiddenAdminPage("lib", new LibLocator());
        adminApp.registerHiddenAdminPage("common", new CommonLocator());
    }

    @Bean
    public CeleryMonitorAdminPage celeryMonitorAdminPage(
            WorkerStateProviderHolder celeryMonitor, RabbitPool rabbitPool,
            AliveAppsHolder aliveAppsHolder, SimpleAppName appName,
            Conductor conductor, @Value("${celery-monitor.hosts.conductor.group}") String conductorGroup)
    {
        Supplier<ListF<String>> hosts = StringUtils.isNotEmpty(conductorGroup)
                ? () -> conductor.getGroupHosts(new ConductorGroup(conductorGroup)).map(InternetDomainName::getDomain)
                : Cf::list;

        CeleryMonitorAdminPage
                page = new CeleryMonitorAdminPage(celeryMonitor, rabbitPool, aliveAppsHolder, appName, hosts,
                quellerMonitorHttpClientConfigurator().configure());

        adminApp.registerAdminPage("Monitor", Option.of("Celery"), page);

        return page;
    }

    @Bean
    @OverridableValuePrefix("queller_monitor")
    public HttpClientConfigurator quellerMonitorHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
