<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="xsl xs z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/lib/bootstrap-select.min.js"/>
        <script type="text/javascript" src="/z/r/lib/bootstrap-typeahead.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.serialize-object.min.js"/>
        <script type="text/javascript" src="/z/r/lib/jquery.tablesorter.min.js"/>
        <script type="text/javascript" src="/z/r/common/modal-edit-form.js"/>
        <script type="text/javascript" src="/z/r/common/typeahead-multicomplete.js"/>
        <script type="text/javascript" src="/z/r/celery-monitor/monitor.js"/>
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" type="text/css" href="/z/r/lib/bootstrap-select.min.css"/>
        <link rel="stylesheet" type="text/css" href="/z/r/celery-monitor/monitor.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="page" mode="ajax">
        <html>
            <body>
                <xsl:apply-templates select="." mode="content"/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="content">
        <h3>Info @
            <span id="updatedAt">
                <xsl:value-of select="z:format-date-time(current-dateTime())"/>
            </span>
        </h3>
        <div class="input-group" style="width: 250px;">
            <span class="input-group-addon">
                <input type="checkbox" id="doAutoreload" checked="" aria-label="Do reload"/>
                reload every
            </span>
            <input type="number" id="autoreload" value="5" class="form-control" aria-label="reload interval in seconds"/>
            <span class="input-group-addon">
                seconds
            </span>
        </div>

        <div>
            <h3>Rabbits</h3>

            <table id="rabbits" class="fixed-table table table-striped table-condensed table-bordered">
                <thead>
                    <tr class="header-row">
                        <th class="col-md-2">
                            <a href="#">App</a>
                        </th>
                        <th class="col-md-2">
                            <a href="#">Host</a>
                        </th>
                        <th>
                            <a href="#">Can be used</a>
                        </th>
                        <th>
                            <a href="#">Is healthy</a>
                        </th>
                        <th>
                            <a href="#">Is active</a>
                        </th>
                        <th>
                            <a href="#">Is connected</a>
                        </th>
                        <th>
                            <a href="#">Ready to receive</a>
                        </th>
                        <th class="col-md-1">
                            <a href="#">Sending errors rate</a>
                        </th>
                        <th>
                            <a href="#">Sending duration</a>
                        </th>
                        <th>
                            <a href="#">Ping timeout per minute</a>
                        </th>
                        <th>
                            <a href="#">Ping duration</a>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each select="*/rabbits">
                        <tr>
                            <td>
                                <a href="{../url}">
                                    <xsl:value-of select="../host"/>
                                </a>
                            </td>
                            <td>
                                <xsl:value-of select="host"/>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(can-be-used)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="can-be-used"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(is-healthy)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="is-healthy"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(is-active)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="is-active"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(is-connected)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="is-connected"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(ready-to-receive)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="ready-to-receive"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(sending-error-rate/is-ok)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of
                                            select="format-number(xs:double(sending-error-rate/value), '##0.000')"/>
                                    /
                                    <xsl:value-of select="format-number(xs:double(sending-rate), '##0.000')"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(sending-duration/is-ok)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="format-number(xs:double(sending-duration/value), '##0.0')"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(ping-timeout-per-minute/is-ok)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="format-number(xs:double(ping-timeout-per-minute/value), '##0.0')"/>
                                </span>
                            </td>
                            <td>
                                <xsl:variable name="health-color"
                                              select="if (xs:boolean(ping-duration/is-ok)) then 'black' else 'red' "/>
                                <span style="color:{$health-color}">
                                    <xsl:value-of select="format-number(xs:double(ping-duration/value), '##0.0')"/>
                                </span>
                            </td>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>

            <table id="errors" class="fixed-table table table-striped table-condensed table-bordered">
                <tbody>
                    <xsl:for-each select="*/error">
                        <tr>
                            <td class="col-md-2">
                                <a href="{../url}">
                                    <xsl:value-of select="../host"/>
                                </a>
                            </td>
                            <td class="message">
                                <xsl:value-of select="../error"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>
        </div>
        <xsl:if test="z:is-true(has-workers)">
        <div>
            <h3>Active workers</h3>

            <table id="workers" class="fixed-table table table-striped table-condensed table-bordered">
                <tr class="header-row">
                    <th>Worker ID</th>
                    <th>Last answer</th>
                    <th>Pool</th>
                    <th>Queues</th>
                </tr>
                <xsl:for-each select="workers">
                    <xsl:variable name="workerStopped" select="(pool-size=0) and (active-processes-count=0)"/>
                    <tr>
                        <td>
                            <xsl:value-of select="worker-id"/>
                        </td>
                        <td>
                            <xsl:value-of select="current-dateTime()
                                    - (xs:dateTime('1970-01-01T00:00:00Z') + last-answer * xs:dayTimeDuration('PT0.001S'))"/>
                        </td>
                        <td>
                            <xsl:choose>
                                <xsl:when test="z:is-true(is-java-worker)">
                                    <xsl:text>—</xsl:text>
                                </xsl:when>
                                <xsl:when test="(pool-size=processes-count) or $workerStopped">
                                    <xsl:value-of select="pool-size"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    target: <xsl:value-of select="pool-size"/>,
                                    real:
                                    <xsl:value-of select="processes-count"/>
                                </xsl:otherwise>
                            </xsl:choose>
                            <xsl:if test="not($workerStopped) and not(z:is-true(is-java-worker))">
                                (<xsl:value-of select="active-processes-count"/> active)
                            </xsl:if>
                            <xsl:if test="not(z:is-true(is-consuming)) and (pool-size>0)">
                                <span style="color: red; margin-left: 2em;">is not consuming</span>
                            </xsl:if>
                        </td>
                        <td>
                            <xsl:value-of select="string-join(queues, ', ')"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </table>
        </div>
        </xsl:if>
    </xsl:template>


</xsl:stylesheet>
