$(function() {
    var $rabbits = $('#rabbits'),
        $errors = $('#errors'),
        $workers = $('#workers'),
        $updatedAt = $('#updatedAt');

    var reload = function() {
        $.ajax().done(function(response) {
            var $resp = $('<div>').html(response);

            if ($resp.find('.error .error-message').length) return;

            $updatedAt.text($resp.find('#updatedAt').text());
            $rabbits.find('tbody').replaceWith($resp.find('#rabbits tbody'));
            $errors.find('tbody').replaceWith($resp.find('#errors tbody'));
            $workers.find('tbody').replaceWith($resp.find('#workers tbody'));

            $rabbits.trigger('update');
        });
    };

    var nextReloadTs, rescheduleReload = function() {
        nextReloadTs = $checkbox.prop('checked') ? +new Date() + $interval.val() * 1000 : null;
    };
    var $checkbox = $('#doAutoreload').change(rescheduleReload),
        $interval = $('#autoreload').change(rescheduleReload);

    rescheduleReload();

    window.setInterval(function() {
        if (nextReloadTs && nextReloadTs < new Date()) {
            reload();
            rescheduleReload();
        }
    }, 500);

    $rabbits.tablesorter();
});
