package ru.yandex.chemodan.queller.celery;

import java.util.UUID;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.chemodan.util.bender.BenderJsonNodeUnmarshaller;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.bender.custom.UuidMarshaller;
import ru.yandex.misc.bender.custom.UuidUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;

/**
 * @author dbrylev
 * @author yashunsky
 */
public class CeleryBender {

    public static final BenderConfiguration configuration = new BenderConfiguration(
            new BenderSettings(MembersToBind.WITH_ANNOTATIONS),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(JsonValue.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                    .add(JsonObject.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                    .add(BenderJsonNode.class, new BenderJsonNodeUnmarshaller())
                    .add(DateTime.class, new DateTimeMarshaller(), new DateTimeUnmarshaller())
                    .add(Instant.class, new InstantAsMillisMarshaller(), new InstantAsMillisUnmarshaller())
                    .add(UUID.class, new UuidMarshaller(), new UuidUnmarshaller())
                    .build());

    public static final BenderMapper mapper = new BenderMapper(configuration);

    private static final DateTimeFormatter DATE_TIME_FORMATTER =
            ISODateTimeFormat.dateTime().withOffsetParsed();

    private static class DateTimeMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            return DATE_TIME_FORMATTER.print((DateTime) o);
        }
    }

    private static class DateTimeUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            return DATE_TIME_FORMATTER.parseDateTime(o);
        }
    }
}
