package ru.yandex.chemodan.queller.celery;

import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;

import ru.yandex.chemodan.queller.rabbit.RabbitQueues;

/**
 * @author dbrylev
 */
public class QuellerQueues {
    public static final DirectExchange EXECUTE_EXCHANGE = new DirectExchange("execute", true, false);
    public static final DirectExchange SUBMIT_EXCHANGE = new DirectExchange("submit", true, false);

    public static final Queue SUBMIT_QUEUE = RabbitQueues.durable("submit");
    public static final Queue SECONDARY_SUBMIT_QUEUE = RabbitQueues.durable("secondary_submit");
    public static final Queue STARTED_QUEUE = RabbitQueues.durable("started");
    public static final Queue COMPLETED_QUEUE = RabbitQueues.durable("completed");

    public static final Queue STARTED_REJECTED_QUEUE = RabbitQueues.durable("pgRejected-started");
    public static final Queue COMPLETED_REJECTED_QUEUE = RabbitQueues.durable("pgRejected-completed");
}
