package ru.yandex.chemodan.queller.celery.control;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class CeleryApiRequest {

    @BenderPart(strictName = true, name = "reply_to")
    public final ReplyTo replyTo;

    @BenderPart(name = "destination", wrapperName = "destination")
    public final Option<ListF<String>> destination;

    public final String method;
    public final MapF<String, JsonValue> arguments;
    public final TicketOrNotParsable ticket;

    @BenderBindAllFields
    public static class ReplyTo {
        public final String exchange;
        @BenderPart(strictName = true, name = "routing_key")
        public final String routingKey;

        public ReplyTo(String exchange, String routingKey) {
            this.exchange = exchange;
            this.routingKey = routingKey;
        }
    }

    public CeleryApiRequest(
            String routingKey, String exchange,
            String method, MapF<String, JsonValue> arguments,
            Ticket ticket, Option<ListF<String>> destination)
    {
        replyTo = new ReplyTo(exchange, routingKey);
        this.destination = destination;
        this.method = method;
        this.arguments = arguments;
        this.ticket = TicketOrNotParsable.ticket(ticket);
    }
}
