package ru.yandex.chemodan.queller.celery.control;

import org.junit.Test;

import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class CeleryApiRequestBendingTest {

    @Test
    public void parseAndSerialize() {
        Function2<String, String, String> jsonF = (destination, ticket) -> "{"
                + "\"reply_to\":{\"exchange\":\"exchange\",\"routing_key\":\"routing_key\"},"
                + destination
                + "\"method\":\"kick\","
                + "\"arguments\":{\"delay\":0},"
                + "\"ticket\":\"" + ticket + "\""
                + "}";

        BenderParserSerializer<CeleryApiRequest> ps = CeleryBender.mapper.createParserSerializer(CeleryApiRequest.class);

        String json = jsonF.apply("\"destination\":[\"worker\"],", "not-parsable-ticket");

        CeleryApiRequest parsed = ps.getParser().parseJson(json);

        Assert.equals(json, new String(ps.getSerializer().serializeJson(parsed)));
        Assert.isTrue(parsed.ticket.isNotParsable());

        json = jsonF.apply("", "kick@2016-09-20T16:58:11.211Z@e3665bda-ab5b-4cd5-9505-8eef9b9b139b");

        parsed = ps.getParser().parseJson(json);

        Assert.equals(json, new String(ps.getSerializer().serializeJson(parsed)));
        Assert.isTrue(parsed.ticket.isTicket());
    }

}
