package ru.yandex.chemodan.queller.celery.control;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;

/**
 * @author dbrylev
 */
@Bendable
public class Ticket {
    public final String method;
    public final Instant generatedAt;
    public final UUID uuid;

    public Ticket(String method, Instant generatedAt, UUID uuid) {
        this.method = method;
        this.generatedAt = generatedAt;
        this.uuid = uuid;
    }

    public static Ticket generate(String method) {
        return new Ticket(method, Instant.now(), UUID.randomUUID());
    }

    public Ticket withMethod(String method) {
        return new Ticket(method, generatedAt, uuid);
    }

    @BenderTextValue
    public static Ticket parse(String text) {
        String[] parts = text.split("@");

        String methodName = parts[0];
        Instant generatedAt = Instant.parse(parts[1]);
        UUID uuid = UUID.fromString(parts[2]);

        return new Ticket(methodName, generatedAt, uuid);
    }

    @BenderTextValue
    public String serialize() {
        return Cf.list(method, generatedAt, uuid).mkString("@");
    }

    public static Option<Ticket> parseSafe(String text) {
        try {
            return Option.of(parse(text));
        } catch (RuntimeException e) {
            return Option.empty();
        }
    }

    @Override
    public String toString() {
        return serialize();
    }
}
