package ru.yandex.chemodan.queller.celery.control;

import ru.yandex.bolts.collection.Either;
import ru.yandex.misc.bender.annotation.BenderTextValue;

/**
 * @author dbrylev
 */
public class TicketOrNotParsable {
    private final Either<Ticket, String> ticketOrNotParsable;

    private TicketOrNotParsable(Either<Ticket, String> ticketOrNotParsable) {
        this.ticketOrNotParsable = ticketOrNotParsable;
    }

    public static TicketOrNotParsable ticket(Ticket ticket) {
        return new TicketOrNotParsable(Either.left(ticket));
    }

    public boolean isTicket() {
        return ticketOrNotParsable.isLeft();
    }

    public Ticket getTicket() {
        return ticketOrNotParsable.getLeft();
    }

    public boolean isNotParsable() {
        return ticketOrNotParsable.isRight();
    }

    @BenderTextValue
    public static TicketOrNotParsable parse(String text) {
        return Ticket.parseSafe(text).map(TicketOrNotParsable::ticket)
                .getOrElse(new TicketOrNotParsable(Either.right(text)));
    }

    @BenderTextValue
    public String serialize() {
        return ticketOrNotParsable.fold(Ticket::serialize, s -> s);
    }
}
