package ru.yandex.chemodan.queller.celery.control.callback;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.amqp.core.Message;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.control.Ticket;
import ru.yandex.chemodan.queller.celery.worker.WorkerId;
import ru.yandex.chemodan.util.SingleOrList;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.BenderParserUtils;

/**
 * @author yashunsky
 */
public abstract class CeleryGenericCallback<T extends CeleryReply> {
    private final BenderParser<T> parser;
    public final CeleryControl.Method method;

    public CeleryGenericCallback(Class<T> answerClass, CeleryControl.Method method) {
        parser = CeleryBender.mapper.createParser(answerClass);
        this.method = method;
    }

    public CeleryControl.Method getCeleryMethod() {
        return method;
    }

    private SingleOrList<T> parseNode(BenderJsonNode node) {
        return node.isArray()
                ? SingleOrList.list(node.getArrayElements().map(parser::parseJson))
                : SingleOrList.single(parser.parseJson(node));
    }

    public final void getMessage(Message msg) {
        Ticket ticket = Ticket.parse(msg.getMessageProperties().getHeaders().get("ticket").toString());

        BenderJsonNode node = BenderParserUtils.json(msg.getBody());
        String worker = node.getFieldNames().first();

        Option<BenderJsonNode> answer = node.getField(worker);

        if (answer.isPresent()) {
            CeleryReplyInfo info = new CeleryReplyInfo(
                    WorkerId.parse(worker), new Duration(ticket.generatedAt, Instant.now()));
            onGetSingleOrList(info, parseNode(answer.get()));
        }
    }

    protected abstract void onGetSingleOrList(CeleryReplyInfo info, SingleOrList<T> reply);
}
