package ru.yandex.chemodan.queller.celery.control.callback;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.control.callback.replies.CeleryInspectActiveReply;
import ru.yandex.chemodan.util.SingleOrList;

/**
 * @author yashunsky
 */
public abstract class CeleryInspectActiveCallback
        extends CeleryGenericCallback<CeleryInspectActiveReply>
        implements CeleryListReply<CeleryInspectActiveReply>
{
    public CeleryInspectActiveCallback() {
        super(CeleryInspectActiveReply.class, CeleryControl.Method.INSPECT_ACTIVE);
    }

    protected final void onGetSingleOrList(CeleryReplyInfo info, SingleOrList<CeleryInspectActiveReply> reply) {
        onMessageGet(info, reply.getList());
    }

    public abstract void onMessageGet(CeleryReplyInfo info, ListF<CeleryInspectActiveReply> replies);
}
