package ru.yandex.chemodan.queller.celery.control.callback;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.control.callback.replies.CeleryInspectActiveQueuesReply;
import ru.yandex.chemodan.util.SingleOrList;

/**
 * @author yashunsky
 */
public abstract class CeleryInspectActiveQueuesCallback
        extends CeleryGenericCallback<CeleryInspectActiveQueuesReply>
        implements CeleryListReply<CeleryInspectActiveQueuesReply>
{
    public CeleryInspectActiveQueuesCallback() {
        super(CeleryInspectActiveQueuesReply.class, CeleryControl.Method.INSPECT_ACTIVE_QUEUES);
    }

    protected final void onGetSingleOrList(CeleryReplyInfo info, SingleOrList<CeleryInspectActiveQueuesReply> reply) {
        onMessageGet(info, reply.getList());
    }

    public abstract void onMessageGet(CeleryReplyInfo info, ListF<CeleryInspectActiveQueuesReply> replies);
}
