package ru.yandex.chemodan.queller.celery.control.callback;

import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.control.callback.replies.CeleryInspectStatsReply;
import ru.yandex.chemodan.util.SingleOrList;

/**
 * @author yashunsky
 */
public abstract class CeleryInspectStatsCallback
        extends CeleryGenericCallback<CeleryInspectStatsReply>
        implements CelerySingleReply<CeleryInspectStatsReply>
{
    public CeleryInspectStatsCallback() {
        super(CeleryInspectStatsReply.class, CeleryControl.Method.INSPECT_STATS);
    }

    protected final void onGetSingleOrList(CeleryReplyInfo info, SingleOrList<CeleryInspectStatsReply> reply) {
        onMessageGet(info, reply.getSingle());
    }

    public abstract void onMessageGet(CeleryReplyInfo info, CeleryInspectStatsReply reply);
}
