package ru.yandex.chemodan.queller.celery.control.callback;

import ru.yandex.chemodan.queller.celery.control.CeleryControl;
import ru.yandex.chemodan.queller.celery.control.callback.replies.JavaWorkerInspectStatsReply;
import ru.yandex.chemodan.util.SingleOrList;

/**
 * @author dbrylev
 */
public abstract class JavaWorkerInspectStatsCallback
        extends CeleryGenericCallback<JavaWorkerInspectStatsReply>
        implements CelerySingleReply<JavaWorkerInspectStatsReply>
{
    public JavaWorkerInspectStatsCallback() {
        super(JavaWorkerInspectStatsReply.class, CeleryControl.Method.INSPECT_STATS_JAVA_WORKER);
    }

    protected void onGetSingleOrList(CeleryReplyInfo info, SingleOrList<JavaWorkerInspectStatsReply> reply) {
        onMessageGet(info, reply.getSingle());
    }

    public abstract void onMessageGet(CeleryReplyInfo info, JavaWorkerInspectStatsReply reply);
}
