package ru.yandex.chemodan.queller.celery.control.callback.replies;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.control.callback.CeleryReply;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class CeleryInspectActiveQueuesReply extends DefaultObject implements CeleryReply {
    public final Option<JsonValue> alias;
    @BenderPart(strictName = true, name = "auto_delete")
    public final boolean autoDelete;
    @BenderPart(strictName = true, name = "binding_arguments")
    public final Option<JsonValue> bindingArguments;
    public final ListF<JsonValue> bindings;
    public final boolean durable;
    public final Exchange exchange;
    public final boolean exclusive;
    public final String name;
    @BenderPart(strictName = true, name = "no_ack")
    public final boolean noAck;
    @BenderPart(strictName = true, name = "queue_arguments")
    public final Option<JsonValue> queueArguments;
    @BenderPart(strictName = true, name = "routing_key")
    public final String routingKey;

    @BenderBindAllFields
    public static class Exchange extends DefaultObject {
        public final Option<JsonValue> arguments;
        @BenderPart(strictName = true, name = "auto_delete")
        public final boolean autoDelete;
        @BenderPart(strictName = true, name = "delivery_mode")
        public final int deliveryMode;
        public final boolean durable;
        public final String name;
        public final boolean passive;
        public final String type;

        public Exchange(Option<JsonValue> arguments, boolean autoDelete, int deliveryMode, boolean durable,
                String name, boolean passive, String type)
        {
            this.arguments = arguments;
            this.autoDelete = autoDelete;
            this.deliveryMode = deliveryMode;
            this.durable = durable;
            this.name = name;
            this.passive = passive;
            this.type = type;
        }
    }

    public CeleryInspectActiveQueuesReply(Option<JsonValue> alias, boolean autoDelete,
            Option<JsonValue> bindingArguments, ListF<JsonValue> bindings, boolean durable,
            Exchange exchange, boolean exclusive, String name, boolean noAck,
            Option<JsonValue> queueArguments, String routingKey)
    {
        this.alias = alias;
        this.autoDelete = autoDelete;
        this.bindingArguments = bindingArguments;
        this.bindings = bindings;
        this.durable = durable;
        this.exchange = exchange;
        this.exclusive = exclusive;
        this.name = name;
        this.noAck = noAck;
        this.queueArguments = queueArguments;
        this.routingKey = routingKey;
    }
}
