package ru.yandex.chemodan.queller.celery.control.callback.replies;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.control.callback.CeleryReply;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class CeleryInspectActiveReply extends DefaultObject implements CeleryReply {
    public final boolean acknowledged;
    public final String args;
    @BenderPart(strictName = true, name = "delivery_info")
    public final DeliveryInfo deliveryInfo;
    public final String hostname;
    public final String id;
    public final String kwargs;
    public final String name;
    @BenderPart(strictName = true, name = "time_start")
    public final double timeStart;
    @BenderPart(strictName = true, name = "worker_pid")
    public final int workerPid;

    @BenderBindAllFields
    public static class DeliveryInfo extends DefaultObject {
        public final String exchange;
        public final Option<JsonValue> priority; //TODO: check, what can be here
        public final boolean redelivered;
        @BenderPart(strictName = true, name = "routing_key")
        public final String routingKey;

        public DeliveryInfo(String exchange, Option<JsonValue> priority, boolean redelivered, String routingKey) {
            this.exchange = exchange;
            this.priority = priority;
            this.redelivered = redelivered;
            this.routingKey = routingKey;
        }
    }

    public CeleryInspectActiveReply(boolean acknowledged, String args,
            DeliveryInfo deliveryInfo, String hostname, String id, String kwargs, String name, double timeStart,
            int workerPid)
    {
        this.acknowledged = acknowledged;
        this.args = args;
        this.deliveryInfo = deliveryInfo;
        this.hostname = hostname;
        this.id = id;
        this.kwargs = kwargs;
        this.name = name;
        this.timeStart = timeStart;
        this.workerPid = workerPid;
    }
}
