package ru.yandex.chemodan.queller.celery.control.callback.replies;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.control.callback.CeleryReply;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class CeleryInspectStatsReply extends DefaultObject implements CeleryReply {
    public final Broker broker;
    public final String clock;
    public final int pid;
    public final Pool pool;

    @BenderPart(strictName = true, name = "prefetch_count")
    public final int prefetchCount;
    public final Rusage rusage;
    public final MapF<String, Integer> total;

    @BenderBindAllFields
    public static class Broker extends DefaultObject {
        public final ListF<JsonValue> alternates; //TODO: check, what can be here
        @BenderPart(strictName = true, name = "connect_timeout")
        public final int connectTimeout;
        public final Option<JsonValue> heartbeat; //TODO: check, what can be here
        public final String hostname;
        public final boolean insist;
        @BenderPart(strictName = true, name = "login_method")
        public final String loginMethod;
        public final int port;
        public final boolean ssl;
        public final String transport;
        @BenderPart(strictName = true, name = "transport_options")
        public final JsonValue transportOptions; //TODO: check, what can be here
        @BenderPart(strictName = true, name = "uri_prefix")
        public final Option<String> uriPrefix; //TODO: check, what can be here
        public final String userid;
        @BenderPart(strictName = true, name = "virtual_host")
        public final String virtualHost;

        public Broker(ListF<JsonValue> alternates, int connectTimeout, Option<JsonValue> heartbeat, String hostname,
                boolean insist,
                String loginMethod, int port, boolean ssl, String transport, JsonValue transportOptions,
                Option<String> uriPrefix, String userid, String virtualHost)
        {
            this.alternates = alternates;
            this.connectTimeout = connectTimeout;
            this.heartbeat = heartbeat;
            this.hostname = hostname;
            this.insist = insist;
            this.loginMethod = loginMethod;
            this.port = port;
            this.ssl = ssl;
            this.transport = transport;
            this.transportOptions = transportOptions;
            this.uriPrefix = uriPrefix;
            this.userid = userid;
            this.virtualHost = virtualHost;
        }
    }

    @BenderBindAllFields
    public static class Pool extends DefaultObject {
        @BenderPart(strictName = true, name = "target_processes")
        public final Option<Integer> targetProcesses; // available only in customised Celery
        @BenderPart(strictName = true, name = "is_consuming")
        public final Option<Boolean> isConsuming; // available only in customised Celery

        @BenderPart(strictName = true, name = "max-concurrency")
        public final int maxConcurrency;
        @BenderPart(strictName = true, name = "max-tasks-per-child")
        public final JsonValue maxTasksPerChild; //TODO: choose class. Can be "N/A" or (?) an int
        public final ListF<Integer> processes;
        @BenderPart(strictName = true, name = "put-guarded-by-semaphore")
        public final boolean putGuardedBySemaphore;
        public final ListF<Integer> timeouts;
        public final Writes writes;

        @BenderBindAllFields
        public static class Writes extends DefaultObject {
            public final String all;
            public final String avg;
            public final Inqueues inqueues;
            public final String raw;
            public final int total;

            @BenderBindAllFields
            public static class Inqueues extends DefaultObject {
                public final int active;
                public final int total;

                public Inqueues(int active, int total) {
                    this.active = active;
                    this.total = total;
                }
            }

            public Writes(String all, String avg, Inqueues inqueues, String raw, int total) {
                this.all = all;
                this.avg = avg;
                this.inqueues = inqueues;
                this.raw = raw;
                this.total = total;
            }
        }

        public Pool(Option<Integer> targetProcesses, Option<Boolean> isConsuming, int maxConcurrency,
                JsonValue maxTasksPerChild, ListF<Integer> processes, boolean putGuardedBySemaphore,
                ListF<Integer> timeouts,
                Writes writes)
        {
            this.targetProcesses = targetProcesses;
            this.isConsuming = isConsuming;
            this.maxConcurrency = maxConcurrency;
            this.maxTasksPerChild = maxTasksPerChild;
            this.processes = processes;
            this.putGuardedBySemaphore = putGuardedBySemaphore;
            this.timeouts = timeouts;
            this.writes = writes;
        }
    }

    @BenderBindAllFields
    public static class Rusage extends DefaultObject {
        public final int idrss;
        public final int inblock;
        public final int isrss;
        public final int ixrss;
        public final int majflt;
        public final int maxrss; //TODO: check if int will be enought
        public final int minflt;
        public final int msgrcv;
        public final int msgsnd;
        public final int nivcsw;
        public final int nsignals;
        public final int nswap;
        public final int nvcsw;
        public final int oublock;
        public final double stime;
        public final double utime;

        public Rusage(int idrss, int inblock, int isrss, int ixrss, int majflt, int maxrss, int minflt, int msgrcv,
                int msgsnd,
                int nivcsw, int nsignals, int nswap, int nvcsw, int oublock, double stime, double utime)
        {
            this.idrss = idrss;
            this.inblock = inblock;
            this.isrss = isrss;
            this.ixrss = ixrss;
            this.majflt = majflt;
            this.maxrss = maxrss;
            this.minflt = minflt;
            this.msgrcv = msgrcv;
            this.msgsnd = msgsnd;
            this.nivcsw = nivcsw;
            this.nsignals = nsignals;
            this.nswap = nswap;
            this.nvcsw = nvcsw;
            this.oublock = oublock;
            this.stime = stime;
            this.utime = utime;
        }
    }

    public CeleryInspectStatsReply(Broker broker, String clock, int pid, Pool pool, int prefetchCount,
            Rusage rusage, MapF<String, Integer> total)
    {
        this.broker = broker;
        this.clock = clock;
        this.pid = pid;
        this.pool = pool;
        this.prefetchCount = prefetchCount;
        this.rusage = rusage;
        this.total = total;
    }
}
