package ru.yandex.chemodan.queller.celery.job;

import org.joda.time.Instant;
import org.joda.time.Seconds;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.chemodan.queller.celery.worker.WorkerId;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class CeleryJobBendingTest {

    @Test
    public void parseAndSerialize() {
        String json = "{"
                + "\"task\": \"tasks.raiser\","
                + "\"id\": \"74dcfa15-6523-4762-ad6b-ff36dd509e72\","
                + "\"retries\": 0,"
                + "\"args\": [1, 2],"
                + "\"kwargs\": {\"args\": [1, 2], \"context\":{\"ycrid\": \"XXX\"}},"

                + "\"utc\": true,"
                + "\"expires\": null,"
                + "\"eta\": \"2015-10-09T15:03:29.520103+00:00\","

                + "\"callbacks\": null,"
                + "\"errbacks\": null,"
                + "\"chord\": null,"
                + "\"taskset\": null,"

                +"\"timelimit\": [3, null]"
                + "}";

        CeleryJob parsed = CeleryBender.mapper.createParser(CeleryJob.class).parseJson(json);

        Assert.equals(parsed.args, ((JsonArray) parsed.getKwargs().getTs("args")).getArray());
        Assert.some(3, parsed.getHardTimeLimit().map(Seconds::getSeconds));
        Assert.none(parsed.getSoftTimeLimit());

        byte[] serialized = CeleryBender.mapper.createSerializer(CeleryJob.class).serializeJson(parsed);
        CeleryJob reparsed = CeleryBender.mapper.createParser(CeleryJob.class).parseJson(serialized);

        Assert.equals(parsed, reparsed);
    }

    @Test
    public void contextParseAndSerialize() {
        CeleryJobContext ctx = new CeleryJobContext(
                true, Option.of(Instant.now()), Option.of(Instant.now()),
                Option.of("active"), Option.of("ycrid"), Option.of("host"),
                Option.of(WorkerId.parse("worker@somewhere.com")),
                Option.of(Instant.now()), Option.of(Instant.now()), Option.of("e"), Option.of("s"), Option.of(12));

        JsonObject serialized = ctx.toJson();

        Assert.equals(serialized, CeleryJobContext.fromJson(serialized).toJson());
    }

}
